-- Beispiel für einen Bitmap-Join-Index
-- Als Benutzer HR ausführen
set autotrace on;

select e.first_name, e.last_name, d.department_name, j.job_title
  from employees e
  join departments d on e.department_id = d.department_id
  join jobs j on e.job_id = j.job_id;
   
create bitmap index bix_emp_dept_job
    on employees (d.department_name, j.job_title)
  from employees e, departments d, jobs j
 where e.department_id = d.department_id
   and e.job_id = j.job_id;
   
-- Abfrage (um den Index zu benutzen, muss der (doppelte) INdex auf e.department_id entfernt werden
drop index emp_department_ix;
drop index emp_job_ix;

select e.first_name, e.last_name, d.department_name, j.job_title
  from employees e
  join departments d on e.department_id = d.department_id
  join jobs j on e.job_id = j.job_id
 where d.department_name = 'Administration';
 
-- Ausgangssituation wieder herstellen
create index emp_department_ix on employees(department_id);
create index emp_job_ix on employees(job_id);
drop index bix_emp_dept_job;
